<?php
require_once __DIR__ . '/config.php';

// ============
// Error mode
// ============
if (APP_DEBUG) {
    error_reporting(E_ALL);
    ini_set('display_errors', '1');
    ini_set('display_startup_errors', '1');
} else {
    // Não imprime erros na saída (evita quebrar JSON/criptografia do app)
    error_reporting(E_ALL & ~E_NOTICE & ~E_STRICT & ~E_DEPRECATED);
    ini_set('display_errors', '0');
    ini_set('display_startup_errors', '0');
}

// ============
// Log helpers
// ============
function app_rotate_log_if_needed(string $filePath): void {
    if (!file_exists($filePath)) return;
    $size = @filesize($filePath);
    if ($size === false) return;
    if ($size <= LOG_MAX_BYTES) return;

    $backup = $filePath . LOG_BACKUP_SUFFIX;
    @unlink($backup);
    @rename($filePath, $backup);
}

function app_log_append(string $filePath, string $line): void {
    app_rotate_log_if_needed($filePath);
    @file_put_contents($filePath, $line, FILE_APPEND | LOCK_EX);
}
